//------------------------------------------------------------------------------
// File: RemoveFromSelection.cs
// The primary purpose of this file is to remove the AI component's object
// from being selected and selectable
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! RemoveFromSelection OnEnter
//! \param %aiCmp AI component id
////////////////////////////////////////////////////////////////////////////////
function AISMN_RemoveFromSelection::OnEnter(%this, %aiCmp)
{
   %object = GetThisObject(%aiCmp);
   
   //Remove the object from selection on the client side
   %id = slgGetGhostIndex(%object);
   RemoveObjectFromSelection(%id);
   DisableCollision(%id);
   
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! RemoveFromSelection Update
//! \param %aiCmp AI component id
////////////////////////////////////////////////////////////////////////////////
function AISMN_RemoveFromSelection::Update(%this, %aiCmp)
{
   ReturnValue(%aiCmp, 0);
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Removes an object from the selection list
//! \param %obj Ghost index
////////////////////////////////////////////////////////////////////////////////
function RemoveObjectFromSelection(%obj)
{   
  %count = ClientGroup.getCount();
  for (%i = 0; %i < %count; %i++)
  {
    %cl = ClientGroup.getObject(%i);
    commandToClient(%cl, 'RemoveFromSelection', %obj);
  }
}

////////////////////////////////////////////////////////////////////////////////
//! Disables an object's collision
//! \param %obj Ghost index
////////////////////////////////////////////////////////////////////////////////
function DisableCollision(%obj)
{
   %count = ClientGroup.getCount();
   for (%i = 0; %i < %count; %i++)
   {
      %cl = ClientGroup.getObject(%i);
      commandToClient(%cl, 'DisableCollision', %obj);
   }
}

// End RemoveFromSelection.cs